/////////////////////////////////////////////////////////////
// CINEMA SDK : RENDERING        													 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////
// video post example file - visualize post data
// operates after the image is completly rendered
/////////////////////////////////////////////////////////////

#include "c4d.h"
#include "c4d_symbols.h"

class VisualizePostData : public VideoPostData
{
	public:
		static NodeData *Alloc(void) { return gNew VisualizePostData; }
		virtual LONG Execute(PluginVideoPost *node, VideoPostStruct *vps);
		virtual LONG GetRenderInfo(PluginVideoPost *node) { return VIDEOPOST_REFRESH|VIDEOPOST_STOREFRAGMENTS; }
};

LONG VisualizePostData::Execute(PluginVideoPost *node, VideoPostStruct *vps)
{
	if (vps->vp==VP_RENDER && !vps->open && *vps->error==RAY_OK && !vps->thread->TestBreak())
	{
		VPBuffer *rgba    = C4DOS.Sh->VPGetBuffer(vps->render,VPBUFFER_RGBA,NOTOK);
		RayParameter *ray = vps->vd->GetRayParameter(); // only in VP_INNER & VP_RENDER
		if (!ray)  return RAY_NOMEM;
		if (!rgba) return RAY_NOMEM;

		LONG x1,y1,x2,y2,x,y,cnt;

		// example functions
		LONG cpp = rgba->GetInfo(VPGETINFO_CPP);

		x1 = ray->left;
		y1 = ray->top;
		x2 = ray->right;
		y2 = ray->bottom;
		cnt = x2-x1+1;

		SReal *b,*buffer = (SReal*)GeAlloc(cpp*cnt*sizeof(SReal));
		if (!buffer) return RAY_NOMEM;

		for (y=y1;y<=y2;y++)
		{
			rgba->GetLine(x1,y,cnt,buffer,32,TRUE);

			VPFragment **frag = vps->vd->GetFragments(x1,y,cnt,VPGETFRAGMENTS_Z_P|VPGETFRAGMENTS_N), **ind=frag;
			if (!frag) continue;

			for (b=buffer,x=x1;x<=x2;x++,b+=cpp, ind++)
			{
				Vector col=0.0;
				VPFragment *f;
				for (f=(*ind); f; f=f->next)
					col+=(Vector(Abs(f->n.x),Abs(f->n.y),Abs(f->n.z))*f->weight) ^ f->color;
				
				col/=256.0;

				b[0]=col.x;
				b[1]=col.y;
				b[2]=col.z;
			}

			GeFree(frag);

			rgba->SetLine(x1,y,cnt,buffer,32,TRUE);
		}
		GeFree(buffer);
	}
		
	return RAY_OK;	
}

// be sure to use a unique ID obtained from www.plugincafe.com
#define ID_VISUALIZENORMALS 1000986

Bool RegisterVPVisualizeNormals(void)
{
	// decide by name if the plugin shall be registered - just for user convenience
	String name=GeLoadString(IDS_VPVISUALIZEPOST); if (!name.Content()) return TRUE;
	return RegisterVideoPostPlugin(ID_VISUALIZENORMALS,name,0,VisualizePostData::Alloc,"",0,0);
}
